{------------------------------------------------------------------------------}
{- Program    : TODAY.PAS                                                     -}
{- Programmer : Todd Fiske                                                    -}
{-                                                                            -}
{- Purpose    : Test the UNIXTIME.PAS unit                                    -}
{-                                                                            -}
{- Revision   : 05/16/1996 - first version                                    -}
{- History                                                                    -}
{-                                                                            -}
{- Language   : Turbo Pascal 7.0                                              -}
{-                                                                            -}
{------------------------------------------------------------------------------}
program tpday;

uses
   dos,
   unixtime;

var
   goop : word;
   t    : longint;
   d    : DateTime;

begin
   writeln;
   writeln('"Today is the greatest day I''ve ever known!" - Billy Corgan, Unix aficionado');

   GetDate(d.year, d.month, d.day, goop);        { put system time into }
   GetTime(d.hour, d.min,   d.sec, goop);        { a DateTime record }
   PackUnixTime(d, t);

   writeln;
   writeln(t:1, '   ', FormatUnixTime(t));

   UnpackUnixTime(t, d);

   writeln;
   writeln('year      : ', d.year  : 4);
   writeln('month     : ', d.month : 4);
   writeln('day       : ', d.day   : 4);
   writeln('hour      : ', d.hour  : 4);
   writeln('minute    : ', d.min   : 4);
   writeln('second    : ', d.sec   : 4);
end.
